/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jsftemplating.util.fileStreamer;

import com.sun.jsftemplating.layout.descriptors.handler.HandlerContext;
import com.sun.jsftemplating.util.LogUtil;
import com.sun.jsftemplating.util.fileStreamer.FacesStreamerContext;
import com.sun.jsftemplating.util.fileStreamer.FileStreamer;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.BitSet;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class FileStreamerPhaseListener
implements PhaseListener {
    private static final long serialVersionUID = 1L;
    private static final String INVOCATION_PATH = "com.sun.jsftemplating.INVOCATION_PATH";
    public static final String STATIC_RESOURCE_IDENTIFIER = "/jsft_resource";
    private static final BitSet DONT_ENCODE_SET;
    private static final String XHTML_CONTENT_TYPE = "application/xhtml+xml";
    private static final String APPLICATION_XML_CONTENT_TYPE = "application/xml";
    private static final String TEXT_XML_CONTENT_TYPE = "text/xml";
    private static final char[] AMP_CHARS;

    public PhaseId getPhaseId() {
        return PhaseId.RESTORE_VIEW;
    }

    public void beforePhase(PhaseEvent event) {
        block14: {
            if (event.getPhaseId() == PhaseId.RESTORE_VIEW) {
                FacesContext context = event.getFacesContext();
                ExternalContext extContext = context.getExternalContext();
                String pathInfo = extContext.getRequestPathInfo();
                if (pathInfo == null) {
                    pathInfo = extContext.getRequestServletPath();
                }
                if (pathInfo != null && pathInfo.indexOf(STATIC_RESOURCE_IDENTIFIER) != -1) {
                    String path = null;
                    FacesStreamerContext fsContext = new FacesStreamerContext(context);
                    context.responseComplete();
                    Object obj = extContext.getResponse();
                    HttpServletResponse resp = null;
                    if (obj instanceof HttpServletResponse) {
                        resp = (HttpServletResponse)obj;
                        path = (String)extContext.getRequestParameterMap().get("filename");
                        fsContext.setAttribute("filePath", path);
                        long mod = fsContext.getContentSource().getLastModified(fsContext);
                        if (mod != -1L) {
                            HttpServletRequest req = (HttpServletRequest)extContext.getRequest();
                            long ifModifiedSince = req.getDateHeader("If-Modified-Since");
                            if (ifModifiedSince < mod / 1000L * 1000L) {
                                resp.setDateHeader("Last-Modified", mod);
                                resp.setDateHeader("Expires", new Date().getTime() + 1708667904L);
                            } else {
                                resp.setStatus(304);
                            }
                        }
                    }
                    try {
                        FileStreamer.getFileStreamer(context).streamContent(fsContext);
                    }
                    catch (FileNotFoundException ex) {
                        if (LogUtil.infoEnabled()) {
                            LogUtil.info("JSFT0004", path);
                        }
                        if (resp != null) {
                            try {
                                resp.sendError(404);
                            }
                            catch (IOException iOException) {}
                        }
                    }
                    catch (IOException ex) {
                        if (!LogUtil.infoEnabled()) break block14;
                        LogUtil.info("JSFT0004", path);
                        if (!LogUtil.fineEnabled()) break block14;
                        LogUtil.fine("Resource (" + path + ") not available!", ex);
                    }
                }
            }
        }
    }

    public static String createResourceUrl(FacesContext context, String contentSourceId, String path) {
        if (context == null) {
            context = FacesContext.getCurrentInstance();
        }
        StringBuilder sb = new StringBuilder(64);
        String mapping = FileStreamerPhaseListener.getFacesMapping(context);
        if (mapping.charAt(0) == '/') {
            sb.append(mapping).append(STATIC_RESOURCE_IDENTIFIER);
        } else {
            sb.append(STATIC_RESOURCE_IDENTIFIER).append(mapping);
        }
        sb.append("?").append("contentSourceId").append("=").append(contentSourceId == null ? "resourceCS" : contentSourceId).append("&").append("filename").append("=").append(path);
        String url = null;
        try {
            String contentType;
            String encoding;
            ResponseWriter writer = context.getResponseWriter();
            if (writer != null) {
                encoding = writer.getCharacterEncoding();
                contentType = writer.getContentType();
            } else {
                ExternalContext ec = context.getExternalContext();
                encoding = ec.getRequestCharacterEncoding();
                contentType = ec.getRequestContentType();
            }
            url = FileStreamerPhaseListener.writeURL(sb.toString(), encoding, contentType);
        }
        catch (IOException ex) {
            Logger.getLogger(FileStreamerPhaseListener.class.getName()).log(Level.SEVERE, null, ex);
        }
        return url;
    }

    private static String getFacesMapping(FacesContext context) {
        if (context == null) {
            throw new NullPointerException("The FacesContext was null.");
        }
        ExternalContext extContext = context.getExternalContext();
        String mapping = (String)extContext.getRequestMap().get(INVOCATION_PATH);
        if (mapping == null) {
            Object request = extContext.getRequest();
            String servletPath = null;
            String pathInfo = null;
            if (request instanceof HttpServletRequest) {
                servletPath = extContext.getRequestServletPath();
                pathInfo = extContext.getRequestPathInfo();
            }
            mapping = FileStreamerPhaseListener.getMappingForRequest(servletPath, pathInfo);
        }
        if ("/*".equals(mapping)) {
            throw new FacesException("The FacesServlet was configured incorrectly");
        }
        if (mapping != null) {
            extContext.getRequestMap().put(INVOCATION_PATH, mapping);
        }
        return mapping;
    }

    private static String getMappingForRequest(String servletPath, String pathInfo) {
        if (servletPath == null) {
            return null;
        }
        if (servletPath.length() == 0) {
            return "/*";
        }
        if (pathInfo != null) {
            return servletPath;
        }
        if (servletPath.indexOf(46) < 0) {
            return servletPath;
        }
        return servletPath.substring(servletPath.lastIndexOf(46));
    }

    public void afterPhase(PhaseEvent arg0) {
    }

    public static void getResourceUrl(HandlerContext hc) {
        hc.setOutputValue("url", FileStreamerPhaseListener.createResourceUrl(hc.getFacesContext(), (String)hc.getInputValue("contentSourceId"), (String)hc.getInputValue("path")));
    }

    private static String writeURL(String text, String queryEncoding, String contentType) throws IOException {
        StringBuilder sb = new StringBuilder();
        int length = text.length();
        for (int i = 0; i < length; ++i) {
            char ch = text.charAt(i);
            if (ch < '!' || ch > '~') {
                if (ch == ' ') {
                    sb.append('+');
                    continue;
                }
                if (ch == ':') continue;
                sb.append('%');
                sb.append(FileStreamerPhaseListener.intToHex((i >> 4) % 16));
                sb.append(FileStreamerPhaseListener.intToHex(i % 16));
                continue;
            }
            if (ch == '\"') {
                sb.append("%22");
                continue;
            }
            if (ch == '?') {
                sb.append('?');
                FileStreamerPhaseListener.encodeURIString(sb, text, queryEncoding, FileStreamerPhaseListener.isXml(contentType), i + 1);
                break;
            }
            sb.append(ch);
        }
        return sb.toString();
    }

    private static char intToHex(int i) {
        if (i < 10) {
            return (char)(48 + i);
        }
        return (char)(65 + (i - 10));
    }

    private static boolean isXml(String contentType) {
        return XHTML_CONTENT_TYPE.equals(contentType) || APPLICATION_XML_CONTENT_TYPE.equals(contentType) || TEXT_XML_CONTENT_TYPE.equals(contentType);
    }

    private static boolean isAmpEscaped(String text, int idx) {
        int i = 1;
        int ix = idx;
        while (i < AMP_CHARS.length) {
            if (text.charAt(ix) != AMP_CHARS[i]) {
                return false;
            }
            ++i;
            ++ix;
        }
        return true;
    }

    private static void encodeURIString(StringBuilder out, String text, String encoding, boolean isXml, int start) throws IOException {
        StringBuilder buf = new StringBuilder();
        int length = text.length();
        for (int i = start; i < length; ++i) {
            char ch = text.charAt(i);
            if (DONT_ENCODE_SET.get(ch)) {
                if (isXml && ch == '&') {
                    if (i + 1 < length && FileStreamerPhaseListener.isAmpEscaped(text, i + 1)) {
                        out.append(ch);
                        continue;
                    }
                    out.append(AMP_CHARS);
                    continue;
                }
                out.append(ch);
                continue;
            }
            buf.append(ch);
            int size = buf.length();
            for (int j = 0; j < size; ++j) {
                out.append('%');
                out.append(FileStreamerPhaseListener.intToHex((buf.charAt(j) + 256 >> 4) % 16));
                out.append(FileStreamerPhaseListener.intToHex(buf.charAt(j) + '\u0000'));
            }
            buf = new StringBuilder();
        }
    }

    static {
        int i;
        DONT_ENCODE_SET = new BitSet(256);
        AMP_CHARS = "&amp;".toCharArray();
        for (i = 97; i <= 122; ++i) {
            DONT_ENCODE_SET.set(i);
        }
        for (i = 65; i <= 90; ++i) {
            DONT_ENCODE_SET.set(i);
        }
        for (i = 48; i <= 57; ++i) {
            DONT_ENCODE_SET.set(i);
        }
        DONT_ENCODE_SET.set(37);
        DONT_ENCODE_SET.set(43);
        DONT_ENCODE_SET.set(35);
        DONT_ENCODE_SET.set(38);
        DONT_ENCODE_SET.set(61);
        DONT_ENCODE_SET.set(45);
        DONT_ENCODE_SET.set(95);
        DONT_ENCODE_SET.set(46);
        DONT_ENCODE_SET.set(42);
        DONT_ENCODE_SET.set(126);
        DONT_ENCODE_SET.set(47);
        DONT_ENCODE_SET.set(39);
        DONT_ENCODE_SET.set(33);
        DONT_ENCODE_SET.set(40);
        DONT_ENCODE_SET.set(41);
        DONT_ENCODE_SET.set(59);
        DONT_ENCODE_SET.set(58);
    }
}

