/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.mgmt.transport.grizzly.grizzly2;

import com.sun.enterprise.ee.cms.impl.base.GMSThreadFactory;
import com.sun.enterprise.ee.cms.impl.base.PeerID;
import com.sun.enterprise.ee.cms.impl.base.Utility;
import com.sun.enterprise.ee.cms.impl.common.GMSContext;
import com.sun.enterprise.ee.cms.impl.common.GMSContextFactory;
import com.sun.enterprise.ee.cms.impl.common.GMSMonitor;
import com.sun.enterprise.mgmt.transport.BlockingIOMulticastSender;
import com.sun.enterprise.mgmt.transport.MessageEvent;
import com.sun.enterprise.mgmt.transport.NetworkUtility;
import com.sun.enterprise.mgmt.transport.VirtualMulticastSender;
import com.sun.enterprise.mgmt.transport.grizzly.GrizzlyConfigConstants;
import com.sun.enterprise.mgmt.transport.grizzly.GrizzlyNetworkManager;
import com.sun.enterprise.mgmt.transport.grizzly.GrizzlyPeerID;
import com.sun.enterprise.mgmt.transport.grizzly.PingMessageListener;
import com.sun.enterprise.mgmt.transport.grizzly.PongMessageListener;
import com.sun.enterprise.mgmt.transport.grizzly.grizzly2.ConnectionCache;
import com.sun.enterprise.mgmt.transport.grizzly.grizzly2.GrizzlyTCPMessageSender;
import com.sun.enterprise.mgmt.transport.grizzly.grizzly2.MessageDispatcherFilter;
import com.sun.enterprise.mgmt.transport.grizzly.grizzly2.MessageFilter;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.PortRange;
import org.glassfish.grizzly.Processor;
import org.glassfish.grizzly.SocketConnectorHandler;
import org.glassfish.grizzly.config.SSLConfigurator;
import org.glassfish.grizzly.filterchain.BaseFilter;
import org.glassfish.grizzly.filterchain.Filter;
import org.glassfish.grizzly.filterchain.FilterChainBuilder;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.filterchain.NextAction;
import org.glassfish.grizzly.filterchain.TransportFilter;
import org.glassfish.grizzly.nio.transport.TCPNIOConnectorHandler;
import org.glassfish.grizzly.nio.transport.TCPNIOServerConnection;
import org.glassfish.grizzly.nio.transport.TCPNIOTransport;
import org.glassfish.grizzly.nio.transport.TCPNIOTransportBuilder;
import org.glassfish.grizzly.ssl.SSLBaseFilter;
import org.glassfish.grizzly.ssl.SSLEngineConfigurator;
import org.glassfish.grizzly.ssl.SSLFilter;
import org.glassfish.grizzly.threadpool.ThreadPoolConfig;

public class GrizzlyNetworkManager2
extends GrizzlyNetworkManager {
    public static final String MESSAGE_CONNECTION_TAG = "connection";
    private static final int SERVER_CONNECTION_BACKLOG = 4096;
    private InetAddress tcpListenerAddress = null;
    private int maxPoolSize;
    private int corePoolSize;
    private long keepAliveTime;
    private int poolQueueSize;
    private String virtualUriList;
    private ExecutorService multicastSenderThreadPool = null;
    private TCPNIOTransport tcpNioTransport;
    private ConnectionCache tcpNioConnectionCache;
    private SSLEngineConfigurator clientSslEngineConfigurator;
    private SSLEngineConfigurator serverSslEngineConfigurator;
    private Boolean RENEGOTIATE_ON_CLIENTAUTHWANT;
    private final ConcurrentHashMap<String, Instance> instances = new ConcurrentHashMap();

    public void localConfigure(Map properties) {
        this.maxPoolSize = Utility.getIntProperty(GrizzlyConfigConstants.MAX_POOLSIZE.toString(), 50, properties);
        this.corePoolSize = Utility.getIntProperty(GrizzlyConfigConstants.CORE_POOLSIZE.toString(), 20, properties);
        this.keepAliveTime = Utility.getLongProperty(GrizzlyConfigConstants.KEEP_ALIVE_TIME.toString(), 60000L, properties);
        this.poolQueueSize = Utility.getIntProperty(GrizzlyConfigConstants.POOL_QUEUE_SIZE.toString(), 4096, properties);
        this.virtualUriList = Utility.getStringProperty(GrizzlyConfigConstants.DISCOVERY_URI_LIST.toString(), null, properties);
        if (properties != null) {
            this.clientSslEngineConfigurator = (SSLEngineConfigurator)properties.get("CLIENT_SSLENGINECONFIGURATOR");
            if (this.clientSslEngineConfigurator != null) {
                this.logConfig("gms client ssl engine configurator", this.clientSslEngineConfigurator);
            }
            this.serverSslEngineConfigurator = (SSLEngineConfigurator)properties.get("SERVER_SSLENGINECONFIGURATOR");
            if (this.serverSslEngineConfigurator != null) {
                this.logConfig("gms server ssl engine configurator", this.serverSslEngineConfigurator);
            }
            this.RENEGOTIATE_ON_CLIENTAUTHWANT = Utility.getBooleanProperty("SSL_RENEGOTIATE_ON_CLIENTAUTHWANT", false, properties);
            if (this.clientSslEngineConfigurator != null) {
                GrizzlyNetworkManager2.getLogger().config("SSL RENEGOTIATION_ON_CLIENTAUTHWANT=" + this.RENEGOTIATE_ON_CLIENTAUTHWANT);
            }
        }
    }

    private void logConfig(String description, SSLEngineConfigurator engConfig) {
        if (engConfig != null && GrizzlyNetworkManager2.getLogger().isLoggable(Level.CONFIG)) {
            SSLConfigurator sslConfigurator;
            StringBuffer buf = new StringBuffer();
            buf.append(description).append(" SSLEngineConfigurator");
            if (engConfig != null && engConfig instanceof SSLConfigurator && (sslConfigurator = (SSLConfigurator)engConfig).getSslImplementation() != null) {
                buf.append(" [ssl impl=").append(sslConfigurator.getSslImplementation().getImplementationName()).append("]");
            }
            buf.append(" [Enabled Protocols:");
            String[] protocols = engConfig.getEnabledProtocols();
            if (protocols != null) {
                for (String p : protocols) {
                    buf.append(p).append(",");
                }
                buf.append("]");
            }
            buf.append(" Provider=").append(engConfig.getSslContext().getProvider().getName());
            GrizzlyNetworkManager2.getLogger().config(buf.toString());
        }
    }

    @Override
    public synchronized void initialize(String groupName, String instanceName, Map properties) throws IOException {
        TCPNIOTransportBuilder tcpTransportBuilder;
        ThreadPoolConfig threadPoolConfig;
        GMSMonitor monitor;
        super.initialize(groupName, instanceName, properties);
        this.instanceName = instanceName;
        this.groupName = groupName;
        GrizzlyNetworkManager2.getLogger().info("Grizzly 2.0 NetworkManager");
        this.configure(properties);
        this.localConfigure(properties);
        GMSContext ctx = GMSContextFactory.getGMSContext(groupName);
        if (ctx != null && (monitor = ctx.getGMSMonitor()) != null) {
            monitor.setSendWriteTimeout(this.sendWriteTimeoutMillis);
        }
        if ((threadPoolConfig = (tcpTransportBuilder = TCPNIOTransportBuilder.newInstance()).getWorkerThreadPoolConfig()) != null) {
            threadPoolConfig.setPoolName("GMS-GrizzlyControllerThreadPool-Group-" + groupName).setCorePoolSize(this.corePoolSize).setMaxPoolSize(this.maxPoolSize).setQueue(new ArrayBlockingQueue(this.poolQueueSize)).setQueueLimit(this.poolQueueSize).setKeepAliveTime(this.keepAliveTime, TimeUnit.MILLISECONDS).setPriority(5);
        }
        TCPNIOTransport transport = tcpTransportBuilder.build();
        TCPNIOServerConnection serverConnection = transport.bind(this.host != null ? this.host : NetworkUtility.getAnyAddress().getHostAddress(), new PortRange(this.tcpStartPort, this.tcpEndPort), 4096);
        this.tcpListenerAddress = ((InetSocketAddress)serverConnection.getLocalAddress()).getAddress();
        this.tcpPort = ((InetSocketAddress)serverConnection.getLocalAddress()).getPort();
        FilterChainBuilder filterChainBuilder = FilterChainBuilder.stateless();
        filterChainBuilder.add((Filter)new TransportFilter());
        if (this.serverSslEngineConfigurator != null && this.clientSslEngineConfigurator != null) {
            GrizzlyNetworkManager2.getLogger().log(Level.CONFIG, "Configuring SSL for point to point listener filter chain.  ServerSslEngineConfigurator=" + this.serverSslEngineConfigurator);
            filterChainBuilder.add((Filter)new SSLBaseFilter(this.serverSslEngineConfigurator, this.RENEGOTIATE_ON_CLIENTAUTHWANT.booleanValue()));
        }
        filterChainBuilder.add((Filter)new MessageFilter());
        filterChainBuilder.add((Filter)new MessageDispatcherFilter(this));
        transport.setProcessor((Processor)filterChainBuilder.build());
        this.tcpNioTransport = transport;
        FilterChainBuilder senderFilterChainBuilder = FilterChainBuilder.stateless().add((Filter)new TransportFilter());
        if (this.serverSslEngineConfigurator != null && this.clientSslEngineConfigurator != null) {
            GrizzlyNetworkManager2.getLogger().config("Configuring SSL for point to point sender filter chain clientSslEngineConfigurator=" + this.clientSslEngineConfigurator);
            senderFilterChainBuilder.add((Filter)new SSLFilter(this.clientSslEngineConfigurator, this.clientSslEngineConfigurator));
        }
        senderFilterChainBuilder.add((Filter)new CloseOnReadFilter()).add((Filter)new MessageFilter());
        TCPNIOConnectorHandler senderConnectorHandler = ((TCPNIOConnectorHandler.Builder)TCPNIOConnectorHandler.builder((TCPNIOTransport)transport).processor((Processor)senderFilterChainBuilder.build())).build();
        this.tcpNioConnectionCache = new ConnectionCache((SocketConnectorHandler)senderConnectorHandler, this.highWaterMark, this.maxParallelSendConnections, this.numberToReclaim);
    }

    @Override
    public synchronized void start() throws IOException {
        if (this.running) {
            return;
        }
        super.start();
        long transportStartTime = System.currentTimeMillis();
        this.tcpNioTransport.start();
        long durationInMillis = System.currentTimeMillis() - transportStartTime;
        GrizzlyNetworkManager2.getLogger().log(Level.CONFIG, "Grizzly controller listening on {0}:{1}. Transport started in {2} ms", new Object[]{this.tcpListenerAddress, Integer.toString(this.tcpPort), durationInMillis});
        if (this.localPeerID == null) {
            InetAddress firstInetAddress;
            String uniqueHost = this.host;
            if (uniqueHost == null && (firstInetAddress = NetworkUtility.getFirstInetAddress()) != null) {
                uniqueHost = firstInetAddress.getHostAddress();
            }
            if (uniqueHost == null) {
                throw new IOException("can not find an unique host");
            }
            this.localPeerID = new PeerID<GrizzlyPeerID>(new GrizzlyPeerID(uniqueHost, this.tcpPort, this.multicastAddress, this.multicastPort), this.groupName, this.instanceName);
            this.peerIDMap.put(this.instanceName, this.localPeerID);
            if (this.LOG.isLoggable(Level.FINE)) {
                this.LOG.log(Level.FINE, "local peer id = {0}", this.localPeerID);
            }
        }
        this.tcpSender = new GrizzlyTCPMessageSender(this.tcpNioTransport, this.tcpNioConnectionCache, this.localPeerID, this.sendWriteTimeoutMillis);
        this.udpSender = null;
        List<PeerID> virtualPeerIdList = this.getVirtualPeerIDList(this.virtualUriList);
        if (virtualPeerIdList != null && !virtualPeerIdList.isEmpty()) {
            this.vms = new VirtualMulticastSender(this, virtualPeerIdList);
            this.multicastSender = this.vms;
        } else {
            boolean FAIRNESS = true;
            GMSThreadFactory tf = new GMSThreadFactory("GMS-McastMsgProcessor-Group-" + this.groupName + "-thread");
            this.multicastSenderThreadPool = new ThreadPoolExecutor(10, 10, 60000L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(1024, true), tf);
            this.multicastSender = new BlockingIOMulticastSender(this.host, this.multicastAddress, this.multicastPort, this.networkInterfaceName, this.multicastPacketSize, this.localPeerID, this.multicastSenderThreadPool, this.multicastTimeToLive, this);
        }
        if (this.tcpSender != null) {
            this.tcpSender.start();
        }
        if (this.udpSender != null) {
            this.udpSender.start();
        }
        if (this.multicastSender != null) {
            this.multicastSender.start();
        }
        this.addMessageListener(new PingMessageListener());
        this.addMessageListener(new PongMessageListener());
        this.running = true;
    }

    @Override
    public synchronized void stop() throws IOException {
        if (!this.running) {
            return;
        }
        this.running = false;
        super.stop();
        if (this.tcpSender != null) {
            this.tcpSender.stop();
        }
        if (this.udpSender != null) {
            this.udpSender.stop();
        }
        if (this.multicastSender != null) {
            this.multicastSender.stop();
        }
        if (this.multicastSenderThreadPool != null) {
            this.multicastSenderThreadPool.shutdown();
        }
        this.peerIDMap.clear();
        this.pingMessageLockMap.clear();
        this.tcpNioConnectionCache.close();
        this.tcpNioTransport.stop();
    }

    @Override
    public void beforeDispatchingMessage(MessageEvent messageEvent, Map piggyback) {
        if (messageEvent == null) {
            return;
        }
        Connection connection = null;
        if (piggyback != null) {
            connection = (Connection)piggyback.get(MESSAGE_CONNECTION_TAG);
        }
        if (!this.isLeavingMessage(messageEvent)) {
            this.addRemotePeer(messageEvent.getSourcePeerID(), connection);
        }
    }

    public void addRemotePeer(PeerID peerID, Connection connection) {
        if (peerID == null) {
            return;
        }
        if (peerID.equals(this.localPeerID)) {
            return;
        }
        String peerInstanceName = peerID.getInstanceName();
        if (peerInstanceName != null && peerID.getUniqueID() instanceof GrizzlyPeerID) {
            PeerID previous = this.peerIDMap.put(peerInstanceName, peerID);
            if (previous == null && this.LOG.isLoggable(Level.FINE)) {
                this.LOG.log(Level.FINE, "addRemotePeer: {0} peerId:{1}", new Object[]{peerInstanceName, peerID});
            }
            if (connection != null) {
                this.obtainInstance(peerInstanceName).register(connection);
            }
        }
        this.addToVMS(peerID);
    }

    @Override
    public void removeRemotePeer(String instanceName) {
        Instance instance = this.instances.remove(instanceName);
        if (instance != null) {
            instance.close();
        }
    }

    @Override
    protected Logger getGrizzlyLogger() {
        return Grizzly.logger(GrizzlyNetworkManager2.class);
    }

    private Instance obtainInstance(String instance) {
        Instance newInstance;
        Instance instanceObj = this.instances.get(instance);
        if (instanceObj == null && (instanceObj = this.instances.putIfAbsent(instance, newInstance = new Instance())) == null) {
            instanceObj = newInstance;
        }
        return instanceObj;
    }

    static class Instance {
        final AtomicBoolean isClosed = new AtomicBoolean();
        final ConcurrentHashMap<Connection, Long> connections = new ConcurrentHashMap();
        final Connection.CloseListener closeListener = new CloseListener();

        Instance() {
        }

        void register(Connection connection) {
            if (this.connections.putIfAbsent(connection, System.currentTimeMillis()) == null) {
                connection.addCloseListener(this.closeListener);
                if (this.isClosed.get()) {
                    connection.close();
                }
            }
        }

        void close() {
            if (!this.isClosed.getAndSet(true)) {
                Iterator it = ((ConcurrentHashMap.KeySetView)this.connections.keySet()).iterator();
                while (it.hasNext()) {
                    Connection connection = (Connection)it.next();
                    it.remove();
                    connection.close();
                }
            }
        }

        private class CloseListener
        implements Connection.CloseListener {
            private CloseListener() {
            }

            public void onClosed(Connection connection, Connection.CloseType type) throws IOException {
                Instance.this.connections.remove(connection);
            }
        }
    }

    static class CloseOnReadFilter
    extends BaseFilter {
        CloseOnReadFilter() {
        }

        public NextAction handleRead(FilterChainContext ctx) throws IOException {
            ctx.getConnection().close();
            return ctx.getStopAction();
        }
    }
}

